﻿//////////////////////////////////////////////
// CursorManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "Cursor.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <string>
#include <unordered_map>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT CursorManager final : public nkCommon::MaybeSingletonClass<CursorManager>
	{
		public :

			// Getters
			System* getSystem () const ;

			// Memory management
			Cursor* createOrRetrieve (nkMemory::StringView name) ;
			Cursor* record (nkMemory::StringView name, nkMemory::UniquePtr<Cursor> resource) ;
			Cursor* get (nkMemory::StringView name) const ;
			Cursor* getByIndex (unsigned int index) const ;
			void rename (nkMemory::StringView currentName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;
			nkMemory::UniquePtr<Cursor> relinquish (nkMemory::StringView name) ;

			// Cursor management
			void setActiveCursor (Cursor* cursor) ;

		private :

			// Functions
			// Constructor, destructor
			CursorManager (bool isSingleton) noexcept ;
			CursorManager (System* system) noexcept ;
			CursorManager (const CursorManager&) = delete ;

			// Operators
			CursorManager& operator= (const CursorManager&) = delete ;

		private :

			// Attributes
			// Memory
			std::unordered_map<std::string, nkMemory::UniquePtr<Cursor>> _cursors ;
			System* _system ;

			// Active cursor
			Cursor* _activeCursor ;

		private :

			friend class nkCommon::MaybeSingletonClass<CursorManager> ;
			friend class System ;
	} ;
}